
<?php
include 'db.php';

// ১. POST রিকোয়েস্ট চেক
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid Request"]);
    exit;
}

// ২. ডাটা রিসিভ করা
$uid = isset($_POST['uid']) ? $conn->real_escape_string($_POST['uid']) : '';
$game_mode = isset($_POST['game_mode']) ? $conn->real_escape_string($_POST['game_mode']) : '';
$period = isset($_POST['period']) ? $conn->real_escape_string($_POST['period']) : '';
$selection = isset($_POST['selection']) ? $conn->real_escape_string($_POST['selection']) : '';
$amount = isset($_POST['amount']) ? floatval($_POST['amount']) : 0;

if (empty($uid) || $amount <= 0) {
    echo json_encode(["status" => "error", "message" => "Invalid Data"]);
    exit;
}

// ৩. ট্রানজ্যাকশন শুরু (টাকার হিসাব তাই সব একসাথে হতে হবে, ভুল হলে সব ক্যান্সেল হবে)
$conn->begin_transaction();

try {
    // ৪. ইউজারের বর্তমান ব্যালেন্স চেক করা (FOR UPDATE দিয়ে লক করা যাতে ডাবল ক্লিক সমস্যা না হয়)
    $user_query = $conn->query("SELECT id, balance_deposit, balance_winning, referred_by FROM users WHERE uid = '$uid' FOR UPDATE");
    
    if ($user_query->num_rows == 0) {
        throw new Exception("User not found");
    }

    $user = $user_query->fetch_assoc();
    $total_balance = $user['balance_deposit'] + $user['balance_winning'];

    // ব্যালেন্স আছে কিনা চেক
    if ($total_balance < $amount) {
        throw new Exception("Insufficient Balance!");
    }

    // ৫. টাকা কাটার লজিক (আগে ডিপোজিট থেকে কাটবে, কম পড়লে উইনিং থেকে)
    $new_deposit = $user['balance_deposit'];
    $new_winning = $user['balance_winning'];

    if ($new_deposit >= $amount) {
        $new_deposit -= $amount;
    } else {
        $remaining = $amount - $new_deposit;
        $new_deposit = 0;
        $new_winning -= $remaining;
    }

    // ৬. ইউজারের ব্যালেন্স আপডেট করা
    $update_user = $conn->query("UPDATE users SET balance_deposit = $new_deposit, balance_winning = $new_winning WHERE uid = '$uid'");
    if (!$update_user) throw new Exception("Balance update failed");

    // ৭. বেট হিস্টোরি সেভ করা (Pending অবস্থায়)
    $insert_bet = $conn->query("INSERT INTO bets (user_uid, game_mode, period, selection, amount, status) 
                                VALUES ('$uid', '$game_mode', '$period', '$selection', $amount, 'pending')");
    if (!$insert_bet) throw new Exception("Bet recording failed");

    // ৮. রেফারেল কমিশন লজিক (০.৬%)
    if (!empty($user['referred_by'])) {
        $referrer_uid = $user['referred_by'];
        $commission = $amount * 0.006; // ১০০ টাকায় ০.৬ টাকা

        // রেফারার চেক করা
        $ref_check = $conn->query("SELECT id FROM users WHERE uid = '$referrer_uid'");
        if ($ref_check->num_rows > 0) {
            // ১. আপলাইনের ব্যালেন্স বাড়ানো
            // ২. মোট বোনাস এবং আজকের বোনাস আপডেট করা
            $conn->query("UPDATE users SET 
                          balance_winning = balance_winning + $commission, 
                          total_bonus = total_bonus + $commission,
                          today_bonus = today_bonus + $commission 
                          WHERE uid = '$referrer_uid'");

            // ৩. বোনাস ট্রানজ্যাকশন লগ রাখা
            $conn->query("INSERT INTO transactions (user_uid, type, amount, method, status) 
                          VALUES ('$referrer_uid', 'bonus', $commission, 'Referral Commission', 'approved')");
        }
    }

    // ৯. সব ঠিক থাকলে কমিট (Confirm) করা
    $conn->commit();

    echo json_encode([
        "status" => "success",
        "message" => "Bet Placed Successfully!",
        "new_balance" => number_format($new_deposit + $new_winning, 2)
    ]);

} catch (Exception $e) {
    // কোনো সমস্যা হলে সব রোলব্যাক (বাতিল) করা
    $conn->rollback();
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}

$conn->close();
?>
