
<?php
include 'db.php';

// কোন গেমের রেজাল্ট চেক হবে (30s, 1m, 3m)
$game_mode = isset($_GET['game_mode']) ? $_GET['game_mode'] : '1m';

// API URL সেট করা (আপনার দেওয়া লিঙ্ক অনুযায়ী)
$api_urls = [
    '30s' => 'https://draw.ar-lottery01.com/WinGo/WinGo_30S/GetHistoryIssuePage.json',
    '1m'  => 'https://draw.ar-lottery01.com/WinGo/WinGo_1M/GetHistoryIssuePage.json',
    '3m'  => 'https://draw.ar-lottery01.com/WinGo/WinGo_3M/GetHistoryIssuePage.json'
];

if (!isset($api_urls[$game_mode])) {
    echo json_encode(["status" => "error", "message" => "Invalid Game Mode"]);
    exit;
}

// ১. লাইভ রেজাল্ট আনা
$api_data = file_get_contents($api_urls[$game_mode] . "?ts=" . time());
$json = json_decode($api_data, true);

if (!isset($json['data']['list'][0])) {
    echo json_encode(["status" => "error", "message" => "API Error"]);
    exit;
}

// লেটেস্ট রেজাল্ট
$latest = $json['data']['list'][0];
$period = $latest['issueNumber'];
$result_number = intval($latest['number']);

// ২. চেক করা এই পিরিয়ড এর কাজ আগেই করা হয়েছে কিনা
// (আমরা bets টেবিলে চেক করবো এই পিরিয়ডে কোনো 'pending' বেট আছে কিনা)
$check_pending = $conn->query("SELECT id FROM bets WHERE game_mode='$game_mode' AND period='$period' AND status='pending'");

if ($check_pending->num_rows == 0) {
    echo json_encode(["status" => "success", "message" => "Already updated or no bets placed."]);
    exit;
}

// ৩. উইন লজিক ফাংশন
function is_win($selection, $number) {
    // Number Match
    if (is_numeric($selection)) {
        return intval($selection) === $number;
    }
    // Big/Small
    if ($selection === 'Big') return $number >= 5;
    if ($selection === 'Small') return $number <= 4;
    // Colors
    $red = [0, 2, 4, 6, 8];
    $green = [1, 3, 5, 7, 9];
    $violet = [0, 5];
    
    if ($selection === 'Red') return in_array($number, $red);
    if ($selection === 'Green') return in_array($number, $green);
    if ($selection === 'Violet') return in_array($number, $violet);
    
    return false;
}

function get_payout($selection, $number) {
    // Payout Logic
    if (is_numeric($selection)) return 9; // Number Win x9
    if ($selection === 'Violet') return 4.5; // Violet Win x4.5
    // Color Win (Red/Green) special logic for 0 and 5
    if ($selection === 'Red' && $number === 0) return 1.5;
    if ($selection === 'Green' && $number === 5) return 1.5;
    if ($selection === 'Red' || $selection === 'Green') return 2;
    // Big/Small Win x2
    return 2;
}

// ৪. সব পেন্ডিং বেট প্রসেস করা
$pending_bets = $conn->query("SELECT * FROM bets WHERE game_mode='$game_mode' AND period='$period' AND status='pending'");

$count = 0;
while ($bet = $pending_bets->fetch_assoc()) {
    $bet_id = $bet['id'];
    $user_uid = $bet['user_uid'];
    $amount = floatval($bet['amount']);
    $selection = $bet['selection'];
    
    if (is_win($selection, $result_number)) {
        // জিতে গেলে
        $rate = get_payout($selection, $result_number);
        $win_amount = $amount * $rate;
        
        // ব্যালেন্স আপডেট
        $conn->query("UPDATE users SET balance_winning = balance_winning + $win_amount WHERE uid = '$user_uid'");
        
        // বেট স্ট্যাটাস আপডেট
        $conn->query("UPDATE bets SET status = 'win', win_amount = $win_amount, result_number = $result_number WHERE id = $bet_id");
    } else {
        // হেরে গেলে
        $conn->query("UPDATE bets SET status = 'loss', win_amount = 0, result_number = $result_number WHERE id = $bet_id");
    }
    $count++;
}

echo json_encode([
    "status" => "success", 
    "message" => "Result processed for period $period", 
    "processed_bets" => $count,
    "result" => $result_number
]);
?>
