
<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

include '../api/db.php';

$message = "";

// --- অটোমেটিক সেটিংস টেবিল তৈরি (যদি না থাকে) ---
$conn->query("CREATE TABLE IF NOT EXISTS settings (id INT AUTO_INCREMENT PRIMARY KEY, setting_key VARCHAR(50) UNIQUE, setting_value TEXT)");
// ডিফল্ট নোটিশ সেট করা
$conn->query("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('site_notice', 'Welcome to BOT CLUB! Play and Win!')");

// ---------------------------------------------------
// ১. নতুন পেমেন্ট নাম্বার অ্যাড করা
// ---------------------------------------------------
if (isset($_POST['add_number'])) {
    $method = $conn->real_escape_string($_POST['method']);
    $number = $conn->real_escape_string($_POST['number']);
    $label = $conn->real_escape_string($_POST['label']); // Agent / Personal

    if ($conn->query("INSERT INTO payment_numbers (method, number, label) VALUES ('$method', '$number', '$label')")) {
        $message = "<div class='alert success'>Number Added Successfully!</div>";
    } else {
        $message = "<div class='alert error'>Error adding number!</div>";
    }
}

// ---------------------------------------------------
// ২. পেমেন্ট নাম্বার ডিলিট করা
// ---------------------------------------------------
if (isset($_GET['delete_id'])) {
    $id = intval($_GET['delete_id']);
    $conn->query("DELETE FROM payment_numbers WHERE id = $id");
    $message = "<div class='alert success'>Number Deleted!</div>";
}

// ---------------------------------------------------
// ৩. নোটিশ আপডেট করা
// ---------------------------------------------------
if (isset($_POST['update_notice'])) {
    $notice = $conn->real_escape_string($_POST['notice_text']);
    $conn->query("UPDATE settings SET setting_value = '$notice' WHERE setting_key = 'site_notice'");
    $message = "<div class='alert success'>Notice Updated!</div>";
}

// ---------------------------------------------------
// ৪. এডমিন পাসওয়ার্ড পরিবর্তন
// ---------------------------------------------------
if (isset($_POST['change_pass'])) {
    $new_pass = $_POST['new_password'];
    $hash = password_hash($new_pass, PASSWORD_DEFAULT);
    $user = $_SESSION['admin_username'] ?? 'admin'; // ডিফল্ট admin
    
    // username দিয়ে আপডেট
    $conn->query("UPDATE admins SET password = '$hash' WHERE username = 'admin'");
    $message = "<div class='alert success'>Password Changed! Please Login Again.</div>";
}

// --- ডাটা লোড ---
$numbers = $conn->query("SELECT * FROM payment_numbers");
$current_notice_res = $conn->query("SELECT setting_value FROM settings WHERE setting_key = 'site_notice'");
$current_notice = $current_notice_res->fetch_assoc()['setting_value'] ?? '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Settings</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Segoe UI', sans-serif; margin: 0; display: flex; background: #f4f6f9; }
        .sidebar { width: 250px; background: #343a40; color: #fff; height: 100vh; position: fixed; padding-top: 20px; }
        .sidebar a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; }
        .sidebar a:hover { background: #495057; color: #fff; }
        .sidebar i { margin-right: 10px; width: 20px; }
        
        .main-content { margin-left: 250px; padding: 20px; width: 100%; }
        .card { background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); margin-bottom: 20px; }
        
        h3 { margin-top: 0; color: #333; border-bottom: 2px solid #00ffc8; padding-bottom: 5px; display: inline-block; }
        
        /* Forms */
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; }
        input, select, textarea { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        button { padding: 10px 20px; background: #333; color: white; border: none; border-radius: 4px; cursor: pointer; }
        button:hover { background: #000; }
        
        /* Table */
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { padding: 10px; text-align: left; border-bottom: 1px solid #eee; }
        .btn-delete { background: #dc3545; padding: 5px 10px; font-size: 12px; }
        
        .alert { padding: 10px; margin-bottom: 20px; border-radius: 5px; }
        .alert.success { background: #d4edda; color: #155724; }
        .alert.error { background: #f8d7da; color: #721c24; }
    </style>
</head>
<body>

    <!-- Sidebar -->
    <div class="sidebar">
        <h2 style="text-align:center; color:#00ffc8; border:none;">BOT CLUB</h2>
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="users.php"><i class="fas fa-users"></i> Users</a>
        <a href="deposits.php"><i class="fas fa-money-bill-wave"></i> Deposits</a>
        <a href="withdraws.php"><i class="fas fa-hand-holding-usd"></i> Withdrawals</a>
        <a href="settings.php" style="background: #495057; color: #fff;"><i class="fas fa-cogs"></i> Settings</a>
        <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <div class="main-content">
        <?php echo $message; ?>

        <!-- 1. Notice Settings -->
        <div class="card">
            <h3>App Notice</h3>
            <form method="POST">
                <div class="form-group">
                    <label>Website/App Scrolling Notice:</label>
                    <textarea name="notice_text" rows="3"><?php echo htmlspecialchars($current_notice); ?></textarea>
                </div>
                <button type="submit" name="update_notice">Update Notice</button>
            </form>
        </div>

        <!-- 2. Payment Numbers -->
        <div class="card">
            <h3>Manage Payment Numbers</h3>
            
            <!-- Add Form -->
            <form method="POST" style="background: #f9f9f9; padding: 15px; border-radius: 5px; margin-bottom: 20px;">
                <div style="display: grid; grid-template-columns: 1fr 1fr 1fr auto; gap: 10px; align-items: end;">
                    <div>
                        <label>Method</label>
                        <select name="method">
                            <option value="bKash">bKash</option>
                            <option value="Nagad">Nagad</option>
                            <option value="Rocket">Rocket</option>
                        </select>
                    </div>
                    <div>
                        <label>Number</label>
                        <input type="text" name="number" placeholder="017xxxxxxxx" required>
                    </div>
                    <div>
                        <label>Type (Label)</label>
                        <select name="label">
                            <option value="Agent">Agent</option>
                            <option value="Personal">Personal</option>
                        </select>
                    </div>
                    <button type="submit" name="add_number" style="background: #28a745;">+ Add</button>
                </div>
            </form>
            
            <!-- List -->
            <table>
                <thead>
                    <tr>
                        <th>Method</th>
                        <th>Number</th>
                        <th>Type</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $numbers->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $row['method']; ?></td>
                        <td style="font-weight:bold;"><?php echo $row['number']; ?></td>
                        <td><?php echo $row['label']; ?></td>
                        <td>
                            <a href="settings.php?delete_id=<?php echo $row['id']; ?>" class="btn-delete" onclick="return confirm('Delete this number?')">Delete</a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <!-- 3. Admin Security -->
        <div class="card">
            <h3>Change Admin Password</h3>
            <form method="POST">
                <div class="form-group">
                    <label>New Password</label>
                    <input type="text" name="new_password" placeholder="Enter new password" required>
                </div>
                <button type="submit" name="change_pass" style="background: #dc3545;">Change Password</button>
            </form>
        </div>

    </div>

</body>
</html>
