
<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

include '../api/db.php';

$message = "";

// ---------------------------------------------------
// ১. ডিপোজিট অ্যাকশন হ্যান্ডেল করা (Approve/Reject)
// ---------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // --- APPROVE LOGIC ---
    if (isset($_POST['approve_id'])) {
        $trx_id = intval($_POST['approve_id']);
        
        // ট্রানজ্যাকশনটি খুঁজে বের করা (এবং চেক করা এটি পেন্ডিং কিনা)
        $qry = $conn->query("SELECT * FROM transactions WHERE id=$trx_id AND status='pending'");
        
        if ($qry->num_rows > 0) {
            $trx = $qry->fetch_assoc();
            $uid = $trx['user_uid'];
            $amount = $trx['amount'];

            // ডাটাবেস ট্রানজ্যাকশন শুরু (টাকা অ্যাড এবং স্ট্যাটাস চেঞ্জ একসাথে হতে হবে)
            $conn->begin_transaction();
            try {
                // ১. ইউজারের ব্যালেন্স বাড়ানো
                $conn->query("UPDATE users SET balance_deposit = balance_deposit + $amount WHERE uid='$uid'");
                
                // ২. ট্রানজ্যাকশন স্ট্যাটাস আপডেট করা
                $conn->query("UPDATE transactions SET status='approved' WHERE id=$trx_id");
                
                $conn->commit();
                $message = "<div class='alert success'>Deposit Approved & Balance Added!</div>";
            } catch (Exception $e) {
                $conn->rollback();
                $message = "<div class='alert error'>Error updating balance!</div>";
            }
        }
    }
    
    // --- REJECT LOGIC ---
    if (isset($_POST['reject_id'])) {
        $trx_id = intval($_POST['reject_id']);
        $conn->query("UPDATE transactions SET status='rejected' WHERE id=$trx_id");
        $message = "<div class='alert error'>Deposit Rejected!</div>";
    }
}

// ২. সব ডিপোজিট লিস্ট লোড করা (Pending গুলো সবার উপরে থাকবে)
$sql = "SELECT * FROM transactions WHERE type='deposit' ORDER BY FIELD(status, 'pending') DESC, id DESC";
$deposits = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Deposits</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { font-family: 'Segoe UI', sans-serif; margin: 0; display: flex; background: #f4f6f9; }
        .sidebar { width: 250px; background: #343a40; color: #fff; height: 100vh; position: fixed; padding-top: 20px; }
        .sidebar a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; }
        .sidebar a:hover { background: #495057; color: #fff; }
        .sidebar i { margin-right: 10px; width: 20px; }
        
        .main-content { margin-left: 250px; padding: 20px; width: 100%; }
        .card { background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        h2 { margin-top: 0; color: #333; border-bottom: 2px solid #00ffc8; padding-bottom: 10px; display: inline-block; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f1f1f1; color: #333; font-weight: 600; }
        tr:hover { background: #f9f9f9; }
        
        .badge { padding: 5px 10px; border-radius: 4px; font-size: 12px; font-weight: bold; }
        .badge.pending { background: #ffeeba; color: #856404; }
        .badge.approved { background: #d4edda; color: #155724; }
        .badge.rejected { background: #f8d7da; color: #721c24; }
        
        .btn { padding: 6px 12px; border: none; border-radius: 4px; cursor: pointer; color: white; margin-right: 5px; }
        .btn-approve { background: #28a745; }
        .btn-reject { background: #dc3545; }
        
        .alert { padding: 10px; margin-bottom: 20px; border-radius: 5px; }
        .alert.success { background: #d4edda; color: #155724; }
        .alert.error { background: #f8d7da; color: #721c24; }
    </style>
</head>
<body>

    <!-- Sidebar (Same as Dashboard) -->
    <div class="sidebar">
        <h2 style="text-align:center; color:#00ffc8; border:none;">BOT CLUB</h2>
        <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
        <a href="users.php"><i class="fas fa-users"></i> Users</a>
        <a href="deposits.php" style="background: #495057; color: #fff;"><i class="fas fa-money-bill-wave"></i> Deposits</a>
        <a href="withdraws.php"><i class="fas fa-hand-holding-usd"></i> Withdrawals</a>
        <a href="settings.php"><i class="fas fa-cogs"></i> Settings</a>
        <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <div class="main-content">
        <?php echo $message; ?>
        
        <div class="card">
            <h2>Deposit Requests</h2>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User UID</th>
                        <th>Amount</th>
                        <th>Method</th>
                        <th>TrxID</th>
                        <th>Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($deposits->num_rows > 0): ?>
                        <?php while($row = $deposits->fetch_assoc()): ?>
                        <tr>
                            <td>#<?php echo $row['id']; ?></td>
                            <td><?php echo $row['user_uid']; ?></td>
                            <td style="font-weight:bold;">৳<?php echo $row['amount']; ?></td>
                            <td><?php echo $row['method']; ?></td>
                            <td><?php echo $row['trx_id']; ?></td>
                            <td><?php echo date('d M, h:i A', strtotime($row['created_at'])); ?></td>
                            <td>
                                <span class="badge <?php echo $row['status']; ?>">
                                    <?php echo ucfirst($row['status']); ?>
                                </span>
                            </td>
                            <td>
                                <?php if($row['status'] == 'pending'): ?>
                                    <form method="POST" style="display:inline;">
                                        <input type="hidden" name="approve_id" value="<?php echo $row['id']; ?>">
                                        <button type="submit" class="btn btn-approve" onclick="return confirm('Approve this deposit? Balance will be added.')"><i class="fas fa-check"></i></button>
                                    </form>
                                    <form method="POST" style="display:inline;">
                                        <input type="hidden" name="reject_id" value="<?php echo $row['id']; ?>">
                                        <button type="submit" class="btn btn-reject" onclick="return confirm('Reject this deposit?')"><i class="fas fa-times"></i></button>
                                    </form>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="8" style="text-align:center;">No deposit records found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</body>
</html>
